/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.WrapperBakedModel;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1095;
import net.minecraft.class_1097;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import slimeknights.mantle.Mantle;

public class ModelHelper {
    private static final Map<class_2248, class_2960> TEXTURE_NAME_CACHE = new ConcurrentHashMap<class_2248, class_2960>();
    public static final SimpleSynchronousResourceReloadListener LISTENER = new SimpleSynchronousResourceReloadListener(){

        public class_2960 getFabricId() {
            return Mantle.getResource("model_helper");
        }

        public void method_14491(class_3300 resourceManager) {
            TEXTURE_NAME_CACHE.clear();
        }
    };

    @Nullable
    public static <T extends class_1087> T getBakedModel(class_2680 state, Class<T> clazz) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft == null) {
            return null;
        }
        class_1087 baked = ModelHelper.unwrap(minecraft.method_1554().method_4743().method_3335(state), clazz);
        if (baked instanceof class_1095) {
            baked = (class_1087)((Pair)((class_1095)baked).field_5427.get(0)).getRight();
        }
        if (baked instanceof class_1097) {
            baked = ((class_1097)baked).field_5435;
        }
        if (clazz.isInstance(baked)) {
            return (T)((class_1087)clazz.cast(baked));
        }
        return null;
    }

    @Nullable
    public static <T extends class_1087> T getBakedModel(class_1935 item, Class<T> clazz) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft == null) {
            return null;
        }
        class_1087 baked = ModelHelper.unwrap(minecraft.method_1480().method_4012().method_3304(item.method_8389()), clazz);
        if (clazz.isInstance(baked)) {
            return (T)((class_1087)clazz.cast(baked));
        }
        return null;
    }

    private static class_2960 getParticleTextureInternal(class_2248 block) {
        class_1058 particle = class_310.method_1551().method_1554().method_4743().method_3335(block.method_9564()).method_4711();
        if (particle != null) {
            return particle.method_45851().method_45816();
        }
        return class_1047.method_4539();
    }

    public static class_2960 getParticleTexture(class_2248 block) {
        return TEXTURE_NAME_CACHE.computeIfAbsent(block, ModelHelper::getParticleTextureInternal);
    }

    public static <T> T arrayToObject(JsonObject json, String name, int size, Function<float[], T> mapper) {
        JsonArray array = class_3518.method_15261((JsonObject)json, (String)name);
        if (array.size() != size) {
            throw new JsonParseException("Expected " + size + " " + name + " values, found: " + array.size());
        }
        float[] vec = new float[size];
        for (int i = 0; i < size; ++i) {
            vec[i] = class_3518.method_15269((JsonElement)array.get(i), (String)(name + "[" + i + "]"));
        }
        return mapper.apply(vec);
    }

    public static Vector3f arrayToVector(JsonObject json, String name) {
        return ModelHelper.arrayToObject(json, name, 3, arr -> new Vector3f(arr[0], arr[1], arr[2]));
    }

    public static int getRotation(JsonObject json, String key) {
        int i = class_3518.method_15282((JsonObject)json, (String)key, (int)0);
        if (i >= 0 && i % 90 == 0 && i / 90 <= 3) {
            return i;
        }
        throw new JsonParseException("Invalid '" + key + "' " + i + " found, only 0/90/180/270 allowed");
    }

    public static <T extends class_1087> class_1087 unwrap(class_1087 model, Class<T> modelClass) {
        while (model instanceof WrapperBakedModel) {
            WrapperBakedModel wrapper = (WrapperBakedModel)model;
            if (modelClass.isAssignableFrom(model.getClass())) {
                return model;
            }
            class_1087 wrapped = wrapper.getWrappedModel();
            if (wrapped == null) {
                return model;
            }
            if (wrapped == model) {
                throw new IllegalArgumentException("Model " + model + " is wrapping itself!");
            }
            model = wrapped;
        }
        return model;
    }

    private ModelHelper() {
    }
}

